/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public final class DatagramPacket {
    byte[] buf;
    int offset;
    int length;
    int bufLength;
    InetAddress address;
    int port;

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getPort() {
        return this.port;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        DatagramPacket.init();
    }

    private static native void init();

    public synchronized byte[] getData() {
        return this.buf;
    }

    public synchronized void setLength(int n2) {
        if (n2 + this.offset > this.buf.length || n2 < 0) {
            throw new IllegalArgumentException("illegal length");
        }
        this.bufLength = this.length = n2;
    }

    public synchronized void setPort(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n2);
        }
        this.port = n2;
    }

    public synchronized void setData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("null packet buffer");
        }
        this.buf = byArray;
        this.offset = 0;
        this.length = byArray.length;
        this.bufLength = byArray.length;
    }

    public DatagramPacket(byte[] byArray, int n2) {
        this(byArray, 0, n2);
    }

    public DatagramPacket(byte[] byArray, int n2, int n3) {
        this.setData(byArray, n2, n3);
        this.address = null;
        this.port = -1;
    }

    public synchronized void setData(byte[] byArray, int n2, int n3) {
        if (n3 < 0 || n2 < 0 || n3 + n2 > byArray.length) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        this.buf = byArray;
        this.length = n3;
        this.bufLength = n3;
        this.offset = n2;
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public DatagramPacket(byte[] byArray, int n2, int n3, InetAddress inetAddress, int n4) {
        this.setData(byArray, n2, n3);
        this.setAddress(inetAddress);
        this.setPort(n4);
    }

    public DatagramPacket(byte[] byArray, int n2, InetAddress inetAddress, int n3) {
        this(byArray, 0, n2, inetAddress, n3);
    }

    public synchronized SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public synchronized void setSocketAddress(SocketAddress socketAddress) {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.setAddress(inetSocketAddress.getAddress());
        this.setPort(inetSocketAddress.getPort());
    }

    public DatagramPacket(byte[] byArray, int n2, int n3, SocketAddress socketAddress) throws SocketException {
        this.setData(byArray, n2, n3);
        this.setSocketAddress(socketAddress);
    }

    public DatagramPacket(byte[] byArray, int n2, SocketAddress socketAddress) throws SocketException {
        this(byArray, 0, n2, socketAddress);
    }
}

